*** COS 2019 02, last update 2023 05  
           
program define dq_hlp_svl  
syntax , [clustervars(string) varlabs(int 0) structure(string) decimals(int 2) outcheck(int 1) outsens(int 1) outintegrate(int 1)  indent(int 0)]  
local indent=`indent'+5  
local adoname "dq_hlp_svl"  
local text_i "di as text _n "  					  
if `varlabs'==1 {  
	capture lab var reportname 						"Storing name of the report"  
	capture lab var segmentname 					"Name of examination segment"  
	capture lab var subgroupname 					"Name of subgroup"  
	capture lab var originaldataset_varnum 			"Number of variables in dataset"  
	capture lab var dataset_initalobsnum 			"Number of cases in original dataset"  
	capture lab var dataset_obsnum 					"Number of cases in original dataset used for data quality analyses"  
	          
	capture lab var pointer 						"Pointer to study variable"  
	capture lab var modified 						"Original or post check variable"  
	capture lab var variable_roleshort 				"Variabletypes for outcome and other variables"  
	capture lab var variablerole 					"Variable type name"  
	capture lab var variable_rolenumber 			"Variable type number"  
	          
	capture lab var var_name 							"Study variable name"  
	capture lab var varlabel 							"Study variable - long label"  
	capture lab var varshortlabel	 						"Study variable - short label"  
	capture lab var changeall_`structure' 			"Number of any modifications"  
	capture lab var changemiss_`structure' 			"Number of modifications related to missings"  
	capture lab var changerv_`structure'	 		"Number of range violations recoded to missing"  
	capture lab var changeextreme_`structure'	 	"Number of outliers recoded to missing"  
	capture lab var changebinaryrecode_`structure'	"Number of recodings conducted for 0-1 binary codes"  
	capture lab var refcat_`structure'				"Reference vs. Event categories used for binary recoding"  
	capture lab var key_device  					"Device associated with study variable"  
	capture lab var key_observer 					"Observer (examiner) associated with study variable"  
	capture lab var key_time  						"Date-Time stamp associated with study variable"  
	          
	capture lab var graph_hist_`structure'   		"Location for Histogram"  
	capture lab var graph_mp1_`structure' 			"Location for Margins plot"  
		         
	          
	          
	*** Results from ado dq_com_im1  
	capture confirm var im1_any_PE_`structure'_dqi  
	if _rc==0 {  
		lab var im1_any_PE_`structure'_dqi			"Data quality indicator Missings all"  
		local varnamepass "im1_any_PE_`structure'_dqi"	  
		global `varnamepass'						"$Missings_2 $all_1"  
	}         
	          
	capture lab var im1_nrr1_PE_`structure'_dqi 	"Data quality indicator Nonresponse rate - Item"	  
	capture lab var im1_sysmis_PE_`structure'_dqi 	"Data quality indicator System Missings"	  
	          
	          
	capture lab var im1_any_NU_`structure' 			"Missings all"  
	capture lab var im1_any_PE_`structure' 			"Missings all"  
	capture lab var im1_sysmis_NU_`structure' 		"System Missings count"	  
	capture lab var im1_sysmis_PE_`structure' 		"System Missings"	  
	capture lab var im1_uncl_NU_`structure' 		"Defined Missings count"		  
	capture lab var im1_uncl_PE_`structure' 		"Defined Missings"		  
	capture lab var im1_sh_NU_`structure' 			"Missings Soft- or Hardware count"		  
	capture lab var im1_sh_PE_`structure' 			"Missings Soft- or Hardware"		  
	capture lab var im1_noex_NU_`structure' 		"Missings No examination count"		  
	capture lab var im1_noex_PE_`structure' 		"Missings No examination"		  
	capture lab var im1_refu_NU_`structure' 		"Missings Refusals count"		  
	capture lab var im1_refu_PE_`structure' 		"Missings Refusals"		  
	capture lab var im1_jump_NU_`structure' 		"Missings due to Jumps count"								  
	capture lab var im1_jump_PE_`structure' 		"Missings due to Jumps"								  
	capture lab var im1_valid_NU_`structure' 		"All values without missings/jumps count"	  
	capture lab var im1_valid_PE_`structure' 		"All values without missings/jumps %"	  
	capture lab var im1_rr1_PE_`structure' 			"Response rate - Item"	  
	capture lab var im1_nrr1_PE_`structure' 		"Nonresponse rate - Item"	  
	          
	          
	          
	          
	          
	capture lab var var2_dt							"Data Type Conflict"  
	          
	capture lab var scalelevel						"Scale level"  
		         
		         
	          
	          
	capture lab var vp_N_`structure' 				"N measurements values"  
	capture lab var vp_levels_`structure' 			"Number of variable levels"  
	capture lab var vp_mean_`structure' 			"Mean"  
	capture lab var vp_sd_`structure' 				"Standard deviation"  
	capture lab var vp_kurt_`structure' 			"Kurtosis"  
	capture lab var vp_skew_`structure' 			"Skewness"  
	capture lab var vp_rm1l_`structure' 			"Mean - 1 SD"  
	capture lab var vp_rm1u_`structure' 			"Mean + 1 SD"  
	capture lab var vp_min_`structure' 				"Minimum"  
	capture lab var vp_max_`structure' 				"Maximum"  
	capture lab var vp_p1_`structure' 				"Percentile 1"  
	capture lab var vp_p5_`structure' 				"Percentile 5"  
	capture lab var vp_p10_`structure' 				"Percentile 10"  
	capture lab var vp_p25_`structure' 				"Percentile 25"  
	capture lab var vp_p50_`structure' 				"Median"  
	capture lab var vp_p75_`structure' 				"Percentile 75"  
	capture lab var vp_p90_`structure' 				"Percentile 90"  
	capture lab var vp_p95_`structure' 				"Percentile 95"  
	capture lab var vp_p99_`structure' 				"Percentile 99"  
	capture lab var vp_iqr_`structure' 				"Inter Quartile Range"  
	capture lab var vp_range_`structure' 			"Range"  
	capture lab var vp_percevent_`structure' 		"% Event category"  
	capture lab var vp_percref_`structure' 			"% Reference category"  
	capture lab var vp_Nevent_`structure' 			"N Event category"  
	capture lab var vp_Nref_`structure' 			"N Reference category"  
	          
	          
	          
	          
	          
	capture lab var rv1_hlc_PE_`structure'_dqi 		"Data quality indicator Inadmissible values"	  
	capture lab var rv1_slc_PE_`structure'_dqi 		"Data quality indicator Uncertain values"	  
	capture lab var rv1_hlc_`structure' 			"Inadmissible values"	  
	capture lab var rv1_slc_`structure' 			"Uncertain values"	  
	          
	capture lab var rv1_hlc_NU_`structure' 			"Inadmissible values"	  
	capture lab var rv1_slc_NU_`structure' 			"Uncertain values"		  
	capture lab var rv1_hlc_PE_`structure' 			"Inadmissible values"	  
	capture lab var rv1_slc_PE_`structure' 			"Uncertain values"		  
	          
	capture lab var rv1_lim_su_`structure' 			"Limit Upper uncertain"	  
	capture lab var rv1_lim_sl_`structure' 			"Limit Lower uncertain"	  
	capture lab var rv1_lim_hu_`structure' 			"Limit Upper inadmissible"	  
	capture lab var rv1_lim_hl_`structure' 			"Limit Lower inadmissible"	  
	          
	capture lab var rv1_su_NU_`structure' 			"Upper uncertain values"	  
	capture lab var rv1_sl_NU_`structure' 			"Lower soft limit values"	  
	capture lab var rv1_hu_NU_`structure' 			"Upper inadmissible values"	  
	capture lab var rv1_hl_NU_`structure' 			"Lower inadmissible values"	  
	          
	capture lab var rv1_su_PE_`structure' 			"Upper uncertain values"	  
	capture lab var rv1_sl_PE_`structure' 			"Lower uncertain values"	  
	capture lab var rv1_hu_PE_`structure' 			"Upper inadmissible values"	  
	capture lab var rv1_hl_PE_`structure' 			"Lower inadmissible values"	  
	          
	          
	capture lab var uo1_dlc_PE_`structure'_dqi 		"Data quality indicator Outliers"	  
	capture lab var uo1_tukl_`structure' 			"Tukey: p25-1.5*IQR lim"  
	capture lab var uo1_tuku_`structure' 			"Tukey: p75+1.5*IQR lim"  
	capture lab var uo1_tukl_NU_`structure' 		"Tukey: p25-1.5*IQR count"  
	capture lab var uo1_tuku_NU_`structure' 		"Tukey: p75+1.5*IQR count"  
		         
	local sdfactor=3*`outsens'  
	dq_hlp_std ,  numstring("`sdfactor'") decimals(`decimals')  indent(`indent')  
	local sdfactor="`r(numstring)'"	  
	capture lab var uo1_sdl_`structure' 			"Mean-`sdfactor'*SD lim"  
	capture lab var uo1_sdu_`structure' 			"Mean+`sdfactor'*SD lim"	  
	capture lab var uo1_sdl_NU_`structure' 			"Mean-`sdfactor'*SD count"  
	capture lab var uo1_sdu_NU_`structure' 			"Mean+`sdfactor'*SD count"	  
	          
	local Grubbslevel=97.5+2.49-2.49/`outsens'  
	dq_hlp_std ,  numstring("`Grubbslevel'") decimals(`decimals')  indent(`indent')  
	local Grubbslevel="`r(numstring)'"	  
	capture lab var uo1_grl_`structure' 			"Grubbs lower CI `Grubbslevel'"  
	capture lab var uo1_gru_`structure' 			"Grubbs upper CI `Grubbslevel'"	  
	capture lab var uo1_grl_NU_`structure' 			"Grubbs lower count"  
	capture lab var uo1_gru_NU_`structure' 			"Grubbs upper count"	  
				       
	local adjTukey=2*`outsens'  
	dq_hlp_std ,  numstring("`sdfactor'") decimals(`decimals')  indent(`indent')  
	local adjTukey="`r(numstring)'"	  
	capture lab var uo1_atukl_`structure' 			"adj. Tukey p10-`adjTukey'*(p25-p5) lim"  
	capture lab var uo1_atuku_`structure' 			"adj. Tukey p90+`adjTukey'*(p95-p75) lim"	  
	capture lab var uo1_atukl_NU_`structure' 		"adj. Tukey p10-`adjTukey'*(p25-p5) count"  
	capture lab var uo1_atuku_NU_`structure' 		"adj. Tukey p90+`adjTukey'*(p95-p75) count"	  
		         
	capture lab var uo1_abpl_`structure' 			"adj. Box-plot lower lim"  
	capture lab var uo1_abpu_`structure' 			"adj. Box-plot upper lim"	  
	capture lab var uo1_abpl_NU_`structure' 		"adj. Box-plot lower count"  
	capture lab var uo1_abpu_NU_`structure' 		"adj. Box-plot upper count"	  
			        
	capture lab var uo1_dlc_`structure' 			"Univariate outliers"	  
	capture lab var uo1_dlc_PE_`structure' 			"Univariate outliers"		  
	capture lab var uo1_dlc_NU_`structure' 			"Univariate outliers"		  
	capture lab var tt1_tt_vp_`structure'_dqi 		"Data quality indicator Time Trend"	  
	capture lab var tt1_tt_vp_`structure' 			"Time Trend Variance proportion"  
	          
		         
	          
	foreach cl of local clustervars  {								  
		local cllabel `cl'_2  
		local bp="vp_`cl'"											  
		         
		if am_rowsum[6,1]>0 {  
			capture lab var icc1_re_`structure'_`cl'_dqi			"Data quality indicator VP rand. effects $`cllabel' $`bp'"  
			capture lab var icc1_fe_`structure'_`cl'_dqi			"Data quality indicator VP fixed effects $`cllabel' $`bp'"  
			capture lab var icc1_re_`structure'_dqi					"Data quality indicator VP rand. effects `structure'"  
			capture lab var icc1_fe_`structure'_dqi					"Data quality indicator VP fixed effects `structure'"  
						     
			capture lab var icc1_re_`structure'_`cl' 				"VP $`cllabel' $`bp'"  
			capture lab var icc1_fe_`structure'_`cl' 				"VP $`cllabel' $`bp'"  
			capture lab var icc1_N_`structure'_`cl' 				"VP N used $`bp'"  
			capture lab var icc1_clused_`structure'_`cl' 			"VP clusters used $`bp'"  
			capture lab var icc1_clall_`structure'_`cl' 			"VP available clusters $`bp'"  
			capture lab var icc1_mean_`structure'_`cl' 				"VP mean cluster size $`bp'"  
			capture lab var icc1_max_`structure'_`cl' 				"VP max cluster size $`bp'"  
			capture lab var icc1_min_`structure'_`cl' 				"VP min cluster size $`bp'"  
		}        
		         
		if am_rowsum[7,1]>0 {  
			capture lab var icc2_icc2_`structure'_`cl'_dqi			"Data quality indicator VP-l2-rand. effects"  
			capture lab var icc2_icc3_`structure'_`cl'_dqi			"Data quality indicator VP-l3-rand. effects"  
			        
			capture lab var icc2_icc2_`structure'_`cl' 				"VP level 2"  
			capture lab var icc2_iccse2_`structure'_`cl' 			"VP l2 s.e."  
			capture lab var icc2_clused2_`structure'_`cl' 			"VP l2 n clusters used"  
			capture lab var icc2_mean2_`structure'_`cl'  			"VP l2 mean cluster n"  
			capture lab var icc2_min2_`structure'_`cl'  			"VP-l2 min cluster n"  
			capture lab var icc2_max2_`structure'_`cl'  			"VP-l2 max cluster n"  
			capture lab var icc2_icc3_`structure'_`cl' 				"VP level 3"  
			capture lab var icc2_iccse3_`structure'_`cl' 			"VP l3 s.e."  
			capture lab var icc2_clused3_`structure'_`cl' 			"VP l3 clusters used"  
			capture lab var icc2_mean3_`structure'_`cl'  			"VP l3 mean cluster n"  
			capture lab var icc2_min3_`structure'_`cl'  			"VP l3 mean cluster n"  
			capture lab var icc2_max3_`structure'_`cl'  			"VP l3 mean cluster n"  
			capture lab var icc2_N_`structure'_`cl' 				"VP N used"  
			capture lab var icc2_icc_`structure'_`cl' 				"VP l2+l3"  
		}        
	}         
}          
end        
